#ifdef _VERSION_CHECK_
	#ifndef MSET
		#ifndef _NOT_INSTANCED_
			
			#version 120
			#extension GL_EXT_gpu_shader4 : enable          
				
		#endif
	#endif
#endif
	
varying vec2 		texcoord;
uniform float 		fade;
varying float		fadeAlpha;
uniform vec4		colorMod;

#ifndef _NOT_INSTANCED_
	uniform samplerBuffer 		WorldPoses;
#endif

attribute vec3	s2_vertex;
attribute vec4	s2_texcoords; 

void main()
{
	vec4 vertex=vec4(s2_vertex,1.0);

	#ifndef _NOT_INSTANCED_
	
		mat4 MTX;
		int index=gl_InstanceID*4;
		MTX[0]=texelFetchBuffer(WorldPoses,index);
		MTX[1]=texelFetchBuffer(WorldPoses,index+1);
		MTX[2]=texelFetchBuffer(WorldPoses,index+2);
		MTX[3]=texelFetchBuffer(WorldPoses,index+3);
		fadeAlpha=MTX[3].w;
		MTX[3].w=1.0;
		gl_Position = (gl_ModelViewProjectionMatrix*MTX)*vertex;
		
		MTX=gl_ModelViewMatrix*MTX;
		vec4 pos=MTX*vertex;
		
	#else
	
		fadeAlpha=fade;
		gl_Position = (gl_ModelViewProjectionMatrix)*vertex;
				
		vec4 pos=gl_ModelViewMatrix*vertex;
		
	#endif
	
	float dist=(length(pos.xyz)-fadeAlpha*0.6)/(fadeAlpha*0.4);
	fadeAlpha=(1.0 - (clamp(dist,0.0,1.0)))*colorMod.a;

	texcoord = s2_texcoords.st;

}